<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Двухфакторная авторизация';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="twofa-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="alert alert-success">
            <?= Yii::$app->session->getFlash('success') ?>
        </div>
    <?php endif; ?>

    <?php if (Yii::$app->session->hasFlash('error')): ?>
        <div class="alert alert-danger">
            <?= Yii::$app->session->getFlash('error') ?>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Статус 2FA</h3>
                </div>
                <div class="panel-body">
                    <?php if ($user->isOtpEnabled()): ?>
                        <p class="text-success">
                            <span class="glyphicon glyphicon-ok"></span>
                            <strong>Двухфакторная авторизация включена</strong>
                        </p>
                        <p>Ваш аккаунт защищен дополнительным уровнем безопасности.</p>
                    <?php else: ?>
                        <p class="text-danger">
                            <span class="glyphicon glyphicon-remove"></span>
                            <strong>Двухфакторная авторизация отключена</strong>
                        </p>
                        <p>Включите 2FA для повышения безопасности вашего аккаунта.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Управление</h3>
                </div>
                <div class="panel-body">
                    <?php if ($user->isOtpEnabled()): ?>
                        <p>Для отключения 2FA введите код из приложения:</p>
                        <form action="<?= Url::to(['disable']) ?>" method="post">
                            <input type="hidden" name="_csrf" value="<?= Yii::$app->request->csrfToken ?>">
                            <div class="form-group">
                                <input type="text" name="code" class="form-control"
                                       placeholder="6-значный код" maxlength="6" required>
                            </div>
                            <?= Html::submitButton('Отключить 2FA', ['class' => 'btn btn-danger']) ?>
                        </form>
                    <?php else: ?>
                        <?= Html::a('Включить 2FA', ['enable'], ['class' => 'btn btn-success btn-lg btn-block']) ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>